/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.util.ArrayList;
import java.util.HashSet;

public class Table {
    private String name = "";
    private final ArrayList<String> items;
    private final ArrayList<String> attributes;
    private final ArrayList<ArrayList<Float>> values;
    private final HashSet<Float> possibleValues = new HashSet();
    private final ArrayList<Boolean> unlockedItems;
    private final ArrayList<Boolean> unlockedAttributes;

    public Table() {
        this.items = new ArrayList();
        this.attributes = new ArrayList();
        this.values = new ArrayList();
        this.unlockedItems = new ArrayList();
        this.unlockedAttributes = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getItem(int index) {
        return this.items.get(index);
    }

    public ArrayList<String> getItemsList() {
        return this.items;
    }

    public ArrayList<String> getAttributesList() {
        return this.attributes;
    }

    public ArrayList<ArrayList<Float>> getValuesList() {
        return this.values;
    }

    public HashSet<Float> getPossibleValues() {
        return this.possibleValues;
    }

    public Boolean isEmpty() {
        return this.items.isEmpty() && this.attributes.isEmpty();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCellValue(Float value, int i, int j) {
        float oldValue = this.values.get(i).get(j).floatValue();
        if (oldValue == value.floatValue()) {
            return;
        }
        this.values.get(i).set(j, value);
        this.possibleValues.add(value);
        for (i = 0; i < this.values.size(); ++i) {
            for (j = 0; j < this.values.get(0).size(); ++j) {
                if (this.values.get(i).get(j).floatValue() != oldValue) continue;
                return;
            }
        }
        this.possibleValues.remove(Float.valueOf(oldValue));
    }

    public void setItemLock(String s, boolean state) {
        this.unlockedItems.set(this.items.indexOf(s), state);
    }

    public void setAttributeLock(String s, boolean state) {
        this.unlockedAttributes.set(this.attributes.indexOf(s), state);
    }

    public void addItem(String item) {
        this.items.add(item);
        this.values.add(new ArrayList());
        this.unlockedItems.add(true);
    }

    public void addValue(Float value, int i) {
        this.possibleValues.add(value);
        this.values.get(i).add(value);
    }

    public void addAttribute(String attribute) {
        this.attributes.add(attribute);
        this.unlockedAttributes.add(true);
    }

    public ArrayList<String> getUnlockedItemsList() {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.unlockedItems.get(i).booleanValue()) continue;
            res.add(this.items.get(i));
        }
        return res;
    }

    public ArrayList<String> getUnlockedAttributesList() {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.unlockedAttributes.get(i).booleanValue()) continue;
            res.add(this.attributes.get(i));
        }
        return res;
    }

    public ArrayList<ArrayList<Float>> getUnlockedValuesList() {
        ArrayList<ArrayList<Float>> res = new ArrayList<ArrayList<Float>>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.unlockedItems.get(i).booleanValue()) continue;
            res.add(new ArrayList());
            for (int j = 0; j < this.attributes.size(); ++j) {
                if (!this.unlockedAttributes.get(j).booleanValue()) continue;
                res.get(res.size() - 1).add(this.values.get(i).get(j));
            }
        }
        return res;
    }

    public String toString() {
        int i;
        String result = this.name;
        for (i = 0; i < this.attributes.size(); ++i) {
            result = result + "\t" + this.attributes.get(i);
        }
        result = result + "\n";
        for (i = 0; i < this.items.size(); ++i) {
            result = result + this.items.get(i) + "\t";
            for (int j = 0; j < this.values.get(i).size(); ++j) {
                result = result + this.values.get(i).get(j).toString() + "\t";
            }
            result = result + "\n";
        }
        return result;
    }
}

